 ; Ŀ
 ;   Vl - lock all vports.                                                 
 ;   Also contains:                                                        
 ;         Vu - unlock all vports.  Just for symmetry.                     
 ;         Vt: reset the view twist angle in the current vport.            
 ;   Copyright 2001, 2006, 2010 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Vprt - see if we are in model space, paper space, or a viewport.      
 ;   Returns a list: a descriptive string: model, paper, or vport          
 ;   and the corner points of either the current screen, if we are in      
 ;   paper or model space, or the corners of the current vport in overall  
 ;   screen coordinates, not those of the viewport itself.                 
 ;   Calls nothing, takes no arguments.                                    
 ; 
 (DEFUN VPRT (/ cvport spac a vs ctr w cornr1 cornr2 cornrs)
  (setq cvport (getvar "cvport"))
 ; Ŀ
 ;   Possibilities: we are in the model tab.                               
 ; 
  (cond ((= (getvar "ctab") "Model")
         (setq spac "Model")
         (setq a (getvar "screensize"))        ; view height & width (pixels)
         (setq a (/ (car a) (cadr a)))         ; view width/height ratio
         (setq vs (* (getvar "viewsize") 0.5)) ; view height in drawing units
         (setq ctr (getvar "viewctr"))         ; centre point of screen
         (setq w (* vs a ))                    ; view half width
         (setq cornr1 (list (- (car ctr) w) (- (cadr ctr) vs)))
         (setq cornr2 (list (+ (car ctr) w) (+ (cadr ctr) vs))))
 ; Ŀ
 ;   In any layout (ps) tab, paper space is always viewport number 1.      
 ; 
        ((= 1 cvport)
         (setq spac "Paper"))
 ; Ŀ
 ;   The default: We are in a viewport in paper space.                     
 ; 
        (t
         (setq spac "Vport")))
 ; Ŀ
 ;   If we are in paper space or a viewport, get the corners.              
 ; 
  (if (= spac "Model")
      (setq cornrs (list cornr1 cornr2))
      (setq cornrs (cdr (assoc cvport (vports)))))
 (list spac cornrs))
 ; Ŀ
 ;   Vprt end.                                                             
 ; 

 ; Ŀ
 ;   Vu - unlock all viewports.                                            
 ; 
 (DEFUN C:VU ()
  (if (= (strcase (getvar "ctab") t) "model")
      (prompt "\n* You Can't Unlock Viewports From Model Space. *")
      (progn
           (command ".mview" "L" "off" "all" "")
           (prompt "\nViewports Unlocked.")))
 (princ))

 ; Ŀ
 ;   Vl - lock all viewports.                                              
 ; 
 (DEFUN C:VL ()
  (if (= (strcase (getvar "ctab") t) "model")
      (prompt "\n* You Can't Lock Viewports From Model Space. *")
      (progn
           (command ".mview" "L" "on" "all" "")
           (prompt "\nViewports Locked.")))
 (princ))

 ; Ŀ
 ;   Vt - change the view twist in a viewport.                             
 ; 
 (DEFUN C:VT (/ pa angg)
  (if (/= (car (vprt)) "Vport")
      (prompt "\nYou should be in a viewport.")
      (progn
           (setq pa (cadr (grread t)))
           (if (null (setq angg (getorient pa "View Twist angle <0>: ")))
               (setq angg 0))
 ; Ŀ
 ;   Getangle returns an angle in radians even if the user inputs i.e. 90. 
 ; 
           (setq angg (* 180 (/ angg pi)))
           (command ".mview" "L" "off" "all" "")
           (command ".dview" "" "tw" angg "")
           (command ".mview" "L" "on" "all" "")))
 (princ))

(prompt "C:VL/C:VU/C:VT")
(princ)
